<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

class Shopier extends PaymentModule
{
    private $html = '';
    private $postErrors = array();
    public function __construct()
    {
        $this->name = 'shopier';
        $this->tab = 'payments_gateways';
        $this->version = '1.7';
        $this->author = 'Shopier';
        $this->module_key = Tools::encrypt($this->name);
        $this->need_instance = 1;
        $this->bootstrap = true;
		$this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);
        parent::__construct();
        $this->displayName = $this->trans('Pay with Credit Card', array(), 'Modules.Shopier.Admin');
        $this->description = $this->trans('Accept payments for Shopier Payment Gateway.', array(), 'Modules.Shopier.Admin');
    }
    public function install()
    {
        if (
            !parent::install() ||
            !$this->registerHook('paymentOptions') ||
            !$this->registerHook('paymentReturn') ||
            !$this->registerHook('actionOrderStatusPostUpdate') ||
            !$this->registerHook('adminOrder') ||
            !$this->createTable()
        ) {
            return false;
        }
        return true;
    }
    public function uninstall()
    {
        if (!parent::uninstall()) {
            return false;
        }
        $this->dropTable();
        return true;
    }
    private function createTable()
    {
        Db::getInstance()->Execute('
            CREATE TABLE IF NOT EXISTS '._DB_PREFIX_.'shopier_payments (
                id_order BIGINT NOT NULL,
                payment_id VARCHAR(255),
                installment VARCHAR (20)
        );');
        return true;
    }
    private function dropTable()
    {
        Db::getInstance()->Execute('DROP TABLE IF EXISTS '._DB_PREFIX_.'shopier_payments');
        return true;
    }
    private function postValidation()
    {
        if (Tools::isSubmit('btnSubmit')) {
            if (!Tools::getValue('api_key')) {
                $this->postErrors[] = $this->trans('API Key is required.', array(), 'Modules.Shopier.Admin');
            } elseif (!Tools::getValue('secret')) {
                $this->postErrors[] = $this->trans('Secret is required.', array(), 'Modules.Shopier.Admin');
            } elseif (!Tools::getValue('paypoint_url')) {
                $this->postErrors[] = $this->trans('Payment Endpoint URL is required.', array(), 'Modules.Shopier.Admin');
            } elseif (!Tools::getValue('shipping_url')) {
                $this->postErrors[] = $this->trans('Shipping Endpoint URL is required.', array(), 'Modules.Shopier.Admin');
            } elseif (!Tools::getValue('cancel_url')) {
                $this->postErrors[] = $this->trans('Cancel Endpoint URL is required.', array(), 'Modules.Shopier.Admin');
            }
        }
    }
    private function postProcess()
    {
        if (Tools::isSubmit('btnSubmit')) {
            $api_key = Tools::getValue('api_key');
            $secret = Tools::getValue('secret');
            $paypoint_url = Tools::getValue('paypoint_url');
            $shipping_url = Tools::getValue('shipping_url');
            $cancel_url = Tools::getValue('cancel_url');
            Configuration::updateValue('shopier_api_key', $api_key);
            Configuration::updateValue('shopier_secret', $secret);
            Configuration::updateValue('shopier_paypoint_url', $paypoint_url);
            Configuration::updateValue('shopier_shipping_url', $shipping_url);
            Configuration::updateValue('shopier_cancel_url', $cancel_url);
        }
        $this->html .= $this->displayConfirmation($this->l('Settings updated.', array(), 'en'));
    }
    public function getContent()
    {
        if (Tools::isSubmit('btnSubmit')) {
            $this->postValidation();
            if (!count($this->postErrors)) {
                $this->postProcess();
            } else {
                foreach ($this->postErrors as $err) {
                    $this->html .= $this->displayError($err);
                }
            }
        } else {
            $this->html .= '<br />';
        }
        $this->html .= $this->renderForm();
        return $this->html;
    }
    public function renderForm()
    {
        $responseUrl = '<span style="font-size:13px">';
        $responseUrl .= $this->trans('I certify that I have provided Shopier with the proper Response URL:', array(), 'Modules.Shopier.Admin');
        $responseUrl .= ' <strong>'.$this->context->link->getModuleLink('shopier', 'response').'</strong></span>';
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->trans('Settings', array(), 'Modules.Shopier.Admin'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->trans('API Key', array(), 'Modules.Shopier.Admin'),
                        'name' => 'api_key',
                        'desc' => $this->trans('This obtained by user from Shopier panel', array(), 'Modules.Shopier.Admin'),
                        'required' => true
                    ),
                    array(
                        'type' => 'password',
                        'label' => $this->trans('Secret', array(), 'Modules.Shopier.Admin'),
                        'name' => 'secret',
                        'desc' => $this->trans('This obtained by user from Shopier panel', array(), 'Modules.Shopier.Admin'),
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Payment Endpoint URL', array(), 'Modules.Shopier.Admin'),
                        'name' => 'paypoint_url',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Shipping Endpoint URL', array(), 'Modules.Shopier.Admin'),
                        'name' => 'shipping_url',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Cancel Endpoint URL', array(), 'Modules.Shopier.Admin'),
                        'name' => 'cancel_url',
                        'required' => true
                    ),
                    array(
                        'type' => 'link',
                        'name' => 'callback',
                        'values' => 1,
                        'desc' => $responseUrl,
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save', array(), 'en'),
                )
            ),
        );
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        if (Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG')) {
            $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        } else {
            $helper->allow_employee_form_lang = 0;
        }
        $this->fields_form = array();
        $helper->id = (int)Tools::getValue('id_carrier');
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'btnSubmit';
        $indexUrl = $this->context->link->getAdminLink('AdminModules', false);
        $indexUrl .= '&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->currentIndex = $indexUrl;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );
        return $helper->generateForm(array($fields_form));
    }
    public function getConfigFieldsValues()
    {
        $api_key = Configuration::get('shopier_api_key');
        $secret = Configuration::get('shopier_secret');
        $paypoint_url = Configuration::get('shopier_paypoint_url');
        $shipping_url = Configuration::get('shopier_shipping_url');
        $cancel_url = Configuration::get('shopier_cancel_url');
        if (empty($paypoint_url)) {
            $paypoint_url = 'https://www.goshopier.com/ShowProduct/api_pay3.php';
        }
        if (empty($shipping_url)) {
            $shipping_url = 'https://www.goshopier.com/pg_sandbox/pg_shipping_info.php';
        }
        if (empty($cancel_url)) {
            $cancel_url = 'https://www.goshopier.com/pg_sandbox/pg_cancel.php';
        }
        return array(
            'api_key' => Tools::getValue('api_key', $api_key),
            'secret' => Tools::getValue('secret', $secret),
            'paypoint_url' => Tools::getValue('paypoint_url', $paypoint_url),
            'shipping_url' => Tools::getValue('shipping_url', $shipping_url),
            'cancel_url' => Tools::getValue('cancel_url', $cancel_url)
        );
    }
    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }
        $cart = $this->context->cart;
        $customer = $this->context->customer;
        $user_id = $customer->id;
        $user_registered = $customer->date_add;
        $time_elapsed = time() - strtotime($user_registered);
        $buyer_account_age = (int)($time_elapsed/86400);
        $id_currency = $cart->id_currency;
        $currency = new Currency($id_currency);
        $currency = $currency->iso_code;
        if ($currency == 'USD') {
            $currency = 1;
        } elseif ($currency == 'EUR') {
            $currency = 2;
        } else {
            $currency = 0;
        }
        $productinfo = "";
        $producttype = '2';
        $items = $cart->getProducts();
        foreach ($items as $item) {
            $productinfo .= $item['name'].';';
            $is_virtual = $item['is_virtual'];
            if ($producttype != 0 && $is_virtual == 1) {
                $producttype = 1;
            } else {
                $producttype = 0;
            }
        }
        $productinfo = str_replace('"', '', $productinfo);
        $productinfo = str_replace('&quot;', '', $productinfo);
		
        $billing = new Address($cart->id_address_invoice);
        $shipping = new Address($cart->id_address_delivery);
        $billingPhone = $billing->phone;
        if (empty($billingPhone)) {
            $billingPhone = $billing->phone_mobile;
        }
        $billingAddress = $billing->address1;
        if (!empty($billing->address2)) {
            $billingAddress .= ' '.$billing->address2;
        }
        if ($billing->id_state > 0) {
            $state = new State($billing->id_state);
            $billingAddress .= ' '.$state->name;
        }
        $country = new Country($billing->id_country);
        if (is_array($country->name)) {
            $billingCountry = $country->name[$cart->id_lang];
        } else {
            $billingCountry = $country->name;
        }
        $shippingPhone = $shipping->phone;
        if (empty($shippingPhone)) {
            $shippingPhone = $shipping->phone_mobile;
        }
        $shippingAddress = $shipping->address1;
        if (!empty($shipping->address2)) {
            $shippingAddress .= ' '.$shipping->address2;
        }
        if ($shipping->id_state > 0) {
            $state = new State($shipping->id_state);
            $shippingAddress .= ' '.$state->name;
        }
        $country = new Country($shipping->id_country);
        if (is_array($country->name)) {
            $shippingCountry = $country->name[$cart->id_lang];
        } else {
            $shippingCountry = $country->name;
        }
        $args = array(
            'API_key' => Configuration::get('shopier_api_key'),
            'platform_order_id' => $cart->id,
            'product_name' => $productinfo,
            'product_type' => $producttype,
            'buyer_name' => $billing->firstname,
            'buyer_surname' => $billing->lastname,
            'buyer_email' => $customer->email,
            'buyer_account_age' => $buyer_account_age,
            'buyer_id_nr' => $user_id,
            'buyer_phone' => $billingPhone,
            'billing_address' => $billingAddress,
            'billing_city' => $billing->city,
            'billing_country' => $billingCountry,
            'billing_postcode' => $billing->postcode,
            'shipping_address' => $shippingAddress,
            'shipping_city' => $shipping->city,
            'shipping_country' => $shippingCountry,
            'shipping_postcode' => $shipping->postcode,
            'total_order_value' => $cart->getOrderTotal(true, Cart::BOTH),
            'currency' => $currency,
            'platform' => 2,
            'is_in_frame' => 0,
			'random_nr' => rand(100000,999999)
        );
        $data = implode('', $args);
        $signature = $this->customHmac($args['random_nr'], Configuration::get('shopier_secret'));
        $signature = base64_encode($signature);
        $args['signature'] = $signature;
        $this->smarty->assign(array(
            'payment_url' => Configuration::get('shopier_paypoint_url'),
            'args' => $args
        ));
		//return $this->display(__FILE__, 'payment.tpl');
		$newOption = new PaymentOption();
        $newOption->setCallToActionText($this->trans('Pay with Credit Card', array(), 'Modules.Shopier.Admin'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true));
       //         ->setAdditionalInformation($this->fetch('module:shopier/views/templates/hook/payment.tpl'));

        return [$newOption];
		//return $this->fetch('module:shopier/views/templates/hook/payment.tpl');
    }
    public function hookPaymentReturn($params)
    {
        if (!$this->active) {
            return;
        }
        $state = $params['objOrder']->getCurrentState();
        if (
            in_array(
                $state,
                array(
                    Configuration::get('PS_OS_PAYMENT'),
                    Configuration::get('PS_OS_OUTOFSTOCK'),
                    Configuration::get('PS_OS_OUTOFSTOCK_UNPAID')
                )
            )) {
            $this->smarty->assign(array(
                'id_order' => $params['objOrder']->id
            ));
        } else {
            $this->smarty->assign('status', 'failed');
        }
        return $this->display(__FILE__, 'payment_return.tpl');
    }
    public function hookAdminOrder($params)
    {
        $id_order = $params['id_order'];
        $transaction = $this->getTransaction($id_order);
        if ($transaction) {
            $this->context->smarty->assign('transaction', $transaction);
            return $this->display(__FILE__, 'admin_order.tpl');
        }
    }
    public function hookActionOrderStatusPostUpdate($params)
    {
        $status = $params['newOrderStatus'];
        $id_order = $params['id_order'];
        $order = new Order($id_order);
        if ($status->id == Configuration::get('PS_OS_SHIPPING')) {
            $carrier = new Carrier($order->id_carrier);
            $args = array(
                'API_key' => Configuration::get('shopier_api_key'),
                'platform_order_id' => $order->id_cart,
                'cargo_company' => $carrier->name,
                'tracking_number' => $order->shipping_number
            );
            $data = implode('', $args);
            $signature = $this->customHmac($data, Configuration::get('shopier_secret'));
            $signature = base64_encode($signature);
            $args['signature'] = $signature;
            $curl = curl_init(Configuration::get('shopier_shipping_url'));
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_TIMEOUT, 30);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($args));
            $data = curl_exec($curl);
            if (curl_error($curl)) {
                curl_close($curl);
            } else {
                curl_close($curl);
            }
        } elseif ($status->id == Configuration::get('PS_OS_CANCELED') ||
            $status->id == Configuration::get('PS_OS_REFUND')) {
            $args = array(
                'API_key' => Configuration::get('shopier_api_key'),
                'platform_order_id' => $order->id_cart,
            );
            $data = implode('', $args);
            $signature = $this->customHmac($data, Configuration::get('shopier_secret'));
            $signature = base64_encode($signature);
            $args['signature'] = $signature;
            $curl = curl_init(Configuration::get('shopier_cancel_url'));
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_TIMEOUT, 30);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($args));
            $data = curl_exec($curl);
            if (curl_error($curl)) {
                curl_close($curl);
            } else {
                curl_close($curl);
            }
        }
    }
    public function addTransaction($id_order, $payment_id, $installment)
    {
        $sql = "INSERT INTO "._DB_PREFIX_."shopier_payments (id_order, payment_id, installment) 
                VALUES ($id_order, '$payment_id', '$installment')";
        Db::getInstance()->execute($sql);
    }
    public function getTransaction($id_order)
    {
        $sql = "SELECT * FROM "._DB_PREFIX_."shopier_payments WHERE id_order=$id_order";
        return Db::getInstance()->getRow($sql);
    }
    public function customHmac($data, $key)
    {
        return @hash_hmac('SHA256', $data, $key, true);
    }
    public function base64Decode($input)
    {
        return base64_decode($input);
    }
}
